/* $Id: osc.h,v 1.10 2012/12/16 20:23:25 protius Exp $
**
** Tommy's Lumonics controller.                   
** Copyright (C) 2011 Tommy Johnson
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or (at
** your option) any later version.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*/

#ifndef OSC_H
#define OSC_H

void osc_init(void);

/* set or clear charge enable
*/
void osc_enable_set(int);

int osc_chargetime(void);

/* Set the max charge time, before a fault is set
*/
void osc_maxchargetimeset(unsigned int);

int osc_enable_get(void);

/* returns true when the charger has achieved its set point
** (the charger also tends to overshoot...)
*/
int osc_ready();

/* set the voltage set point
*/
int osc_voltageset(int v);

/* read the current set point
*/
int osc_voltageget(void);

/* read the current voltage
*/
int osc_voltageread(void);

int osc_energyread(void);

/* returns true on the rising edge of the ready flag
*/
int osc_readycheck(void);

int osc_power_get(void);

#endif
