#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/mman.h>

#include "/usr/src/sys/dev/lux/lux_registers.h"

static char *rcsid="$Id: testreg.c,v 1.1 2002/03/30 05:02:29 protius Exp $";

int sintable[]={0xfe,0xfd,0xfd,0xfd,0xfd,0xfd,0xfd,0xfd,0xfc,0xfc,0xfc,0xfb,0xfb,0xfa,0xfa,0xf9,0xf9,0xf8,0xf7,0xf7,0xf6,0xf5,0xf4,0xf3,0xf3,0xf2,0xf1,0xf0,0xef,0xee,0xec,0xeb,0xea,0xe9,0xe8,0xe7,0xe5,0xe4,0xe3,0xe1,0xe0,0xde,0xdd,0xdb,0xda,0xd8,0xd7,0xd5,0xd3,0xd2,0xd0,0xce,0xcd,0xcb,0xc9,0xc7,0xc6,0xc4,0xc2,0xc0,0xbe,0xbc,0xba,0xb8,0xb6,0xb4,0xb2,0xb0,0xae,0xac,0xaa,0xa8,0xa6,0xa4,0xa2,0x9f,0x9d,0x9b,0x99,0x97,0x95,0x92,0x90,0x8e,0x8c,0x8a,0x87,0x85,0x83,0x81,0x7f,0x7d,0x7b,0x79,0x77,0x74,0x72,0x70,0x6e,0x6c,0x69,0x67,0x65,0x63,0x61,0x5f,0x5c,0x5a,0x58,0x56,0x54,0x52,0x50,0x4e,0x4c,0x4a,0x48,0x46,0x44,0x42,0x40,0x3e,0x3c,0x3a,0x38,0x37,0x35,0x33,0x31,0x30,0x2e,0x2c,0x2b,0x29,0x27,0x26,0x24,0x23,0x21,0x20,0x1e,0x1d,0x1b,0x1a,0x19,0x17,0x16,0x15,0x14,0x13,0x12,0x10,0xf,0xe,0xd,0xc,0xb,0xb,0xa,0x9,0x8,0x7,0x7,0x6,0x5,0x5,0x4,0x4,0x3,0x3,0x2,0x2,0x2,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x2,0x2,0x2,0x3,0x3,0x4,0x4,0x5,0x5,0x6,0x7,0x7,0x8,0x9,0xa,0xb,0xb,0xc,0xd,0xe,0xf,0x10,0x12,0x13,0x14,0x15,0x16,0x17,0x19,0x1a,0x1b,0x1d,0x1e,0x20,0x21,0x23,0x24,0x26,0x27,0x29,0x2b,0x2c,0x2e,0x30,0x31,0x33,0x35,0x37,0x38,0x3a,0x3c,0x3e,0x40,0x42,0x44,0x46,0x48,0x4a,0x4c,0x4e,0x50,0x52,0x54,0x56,0x58,0x5a,0x5c,0x5f,0x61,0x63,0x65,0x67,0x69,0x6c,0x6e,0x70,0x72,0x74,0x77,0x79,0x7b,0x7d,0x7f,0x81,0x83,0x85,0x87,0x8a,0x8c,0x8e,0x90,0x92,0x95,0x97,0x99,0x9b,0x9d,0x9f,0xa2,0xa4,0xa6,0xa8,0xaa,0xac,0xae,0xb0,0xb2,0xb4,0xb6,0xb8,0xba,0xbc,0xbe,0xc0,0xc2,0xc4,0xc6,0xc7,0xc9,0xcb,0xcd,0xce,0xd0,0xd2,0xd3,0xd5,0xd7,0xd8,0xda,0xdb,0xdd,0xde,0xe0,0xe1,0xe3,0xe4,0xe5,0xe7,0xe8,0xe9,0xea,0xeb,0xec,0xee,0xef,0xf0,0xf1,0xf2,0xf3,0xf3,0xf4,0xf5,0xf6,0xf7,0xf7,0xf8,0xf9,0xf9,0xfa,0xfa,0xfb,0xfb,0xfc,0xfc,0xfc,0xfd,0xfd,0xfd,0xfd,0xfd,0xfd,0xfd};

#if 0
int testpattern(char *bufferc)
{
	int x,y;
	for(y=0;y<255;y++)
		for(x=0;x<720;x++)
			bufferc[0x200000 + x + (y*720)]=y;
	for(y=255;y<480;y++)
		for(x=0;x<720;x++)
			bufferc[0x200000 + x + (y*720)]=255-(y-255);
	for(y=0;y<240;y++)
		for(x=0;x<360;x++)
		{
			bufferc[0x254600 + x + (y*360)]=sintable[x%360];
			bufferc[0x269780 + x + (y*360)]=sintable[(x+64) % 360];
		}
}
#else
#define LUX_DRAM_BASE (0x200000 >> 2)
static void testpattern(char *bufferc)
{        
	unsigned int *virbase=(int*)bufferc;
        int x,y,t;
        unsigned char *u = ((char *)(virbase))+0x254600;
        unsigned char *v = ((char *)(virbase))+0x269780;


        for(y=0;y<255;y++)
                for(x=0;x<(720/4);x++)
                        virbase[LUX_DRAM_BASE+ x + ((y*720) >> 2)]=(y << 24) | (y << 16) | (y << 8) |
y;
        for(y=255;y<480;y++)
                for(x=0;x<(720/4);x++)
                {
                        t=255-(y-255);
                        virbase[LUX_DRAM_BASE+x + ((y*720) >> 2)]=(t << 24) | (t << 16) | (t << 8) |
t;      
                }
        for(y=0;y<240;y++)
                for(x=0;x<360;x++)
                {
                        u[x + (y*360)]=sintable[x%360];
                        v[x + (y*360)]=sintable[(x+64) % 360];
                }
}

#endif

/* returns number of bytes in the audio FIFO
*/

static int
audio_length(unsigned int  *virbase)
{
        unsigned int wr,rd;

        wr=virbase[LUX_DSP_FIFO_WRITE];
        rd=virbase[LUX_DSP_FIFO_READ];
        return 0x4000-((wr>=rd)?(0x4000-(wr-rd)):(rd-wr));
}

/* returns number of bytes in the video FIFO
*/
static int
video_length(unsigned int *virbase)
{
        return virbase[LUX_MPEG_VIDEO_FIFO_CURRENT_BYTES];
}



int main(int argc, char *argv[])
{
	int fd,infd;
	unsigned int *buffer;
	unsigned char *bufferc;
	int addr=0,val,i,x,y;
	char line[1024];
	int bufferwatch=0;

	fd=open("/dev/lux0",O_RDWR);
	if (fd<0)
	{
		perror("main: open");
		exit(1);
	}

	buffer=mmap(NULL, 0x00FFFFFF,PROT_READ|PROT_WRITE,0,fd,0);
	bufferc=(char*)buffer;

	if (buffer==MAP_FAILED)
	{
		perror("main: mmap");
		exit(1);
	}

	printf("first 16 registers:\n");
	for(i=0;i<16;i++)
		printf("%x ",buffer[i/4]);

	printf("\n");

#if 0
	memset(&bufferc[0x200000],0x7f,0x1FFFFF);

	for(x=0;x<720;x++)
		for(y=0;y<480;y++)
			bufferc[0x200000 + x + (y*720)]= (x % 20)?0x0:0xFF;
#endif

#if 0
	infd=open("squirl2.raw",O_RDONLY);
	read(infd,&bufferc[0x200000],720*480*2);
	close(infd);
#endif

	testpattern(bufferc);
	
	if (bufferwatch)
	{
		while(1)
		{
			printf("abuff= %d vbuff= %d\n",audio_length(buffer),video_length(buffer));
			sleep(1);
		}
		exit(0);
	}

	while(1)
	{
		fgets(line,sizeof(line),stdin);
		switch(line[0])
		{
			case 'r':
			case 'R':
				sscanf(line+1,"%x",&addr);
			default:
				sscanf(line,"%x",&addr);
			break;
			break;
			case 'e':
			case 'E':
				exit(0);
			break;
			case 's':
			case 'S':
			case '=':
				sscanf(line+1,"%x",&val);
				buffer[addr>>2]=val;
			break;
			case '|':
				sscanf(line+1,"%x",&val);
				buffer[addr>>2]|=val;
			break;
			case '&':
				sscanf(line+1,"%x",&val);
				buffer[addr>>2]&=val;
			break;
			case 'z':
			case 'Z':
				sscanf(line+1,"%x",&val);
				buffer[addr>>2]&=~val;
			break;
			case 'p':
				printf("PTS:  systemtime= %d  audio= %d  video= %d  subpicture= %d\n",buffer[0x218 >> 2],buffer[0x250 >> 2],buffer[0x254 >> 2], buffer[0x258 >> 2]);
		}
		printf("address 0x%08x = 0x%08x\n",addr,buffer[addr>>2]);
		if (addr<0)
			break;
	}
}
