/*
 *	This program contains much of the code from the original
 *	 Sun version of mahjongg, written by Mark Holm, which was
 *	 inspired by the PC version.
 *
 *	This version of Mahjongg was modified/re-written/ported
 *	 for/to the AT&T UNIXPC    by Thomas Tkacik
 *                                 ...rphroy!tetnix!tet.
 *
 *	Any problems or comments should be addressed to Tom Tkacik
 *	 and not Mark Holm, who had nothing to do with this version
 *	 and will not be able to help you.
 *
 */

/*
 *	Copyright 1988, Mark Holm
 *			Exceptions
 *
 *	Permission is given to copy and distribute for non-profit purposes.
 *
 */

#define  ROWS       23
#define  COLS       75
#define  WINDOW_X   2
#define  WINDOW_Y   2

/* TILE size and offsets */
#define  TILE_W  48
#define  TILE_H  32
#define  TILE_X  42
#define  TILE_Y  28

/* TILE offset on playing board */
#define  X_OFF1  20
#define  X_OFF2  (X_OFF1 + TILE_X)
#define  X_OFF3  (X_OFF2 + TILE_X)
#define  X_OFF4  (X_OFF3 + TILE_X)
#define  X_OFF5  (X_OFF4 + TILE_X)
#define  X_OFF6  (X_OFF5 + TILE_X)
#define  X_OFF7  (X_OFF6 + TILE_X)
#define  X_OFF75 (X_OFF7 + (TILE_X/2))
#define  X_OFF8  (X_OFF7 + TILE_X)
#define  X_OFF9  (X_OFF8 + TILE_X)
#define  X_OFF10  (X_OFF9 + TILE_X)
#define  X_OFF11  (X_OFF10 + TILE_X)
#define  X_OFF12  (X_OFF11 + TILE_X)
#define  X_OFF13  (X_OFF12 + TILE_X)
#define  X_OFF14  (X_OFF13 + TILE_X)
#define  X_OFF15  (X_OFF14 + TILE_X)

#define  Y_OFF1  35
#define  Y_OFF2  (Y_OFF1 + TILE_Y)
#define  Y_OFF3  (Y_OFF2 + TILE_Y)
#define  Y_OFF4  (Y_OFF3 + TILE_Y)
#define  Y_OFF45 (Y_OFF4 + (TILE_Y/2))
#define  Y_OFF5  (Y_OFF4 + TILE_Y)
#define  Y_OFF6  (Y_OFF5 + TILE_Y)
#define  Y_OFF7  (Y_OFF6 + TILE_Y)
#define  Y_OFF8  (Y_OFF7 + TILE_Y)

/* offsets due to being on a different level */
#define  X_OFFL2  (TILE_X - TILE_W)
#define  X_OFFL3  ((TILE_X - TILE_W) * 2)
#define  X_OFFL4  ((TILE_X - TILE_W) * 3)
#define  X_OFFL5  ((TILE_X - TILE_W) * 4)

#define  Y_OFFL2  (TILE_Y - TILE_H)
#define  Y_OFFL3  ((TILE_Y - TILE_H) * 2)
#define  Y_OFFL4  ((TILE_Y - TILE_H) * 3)
#define  Y_OFFL5  ((TILE_Y - TILE_H) * 4)

/* more TILE data */
#define  IMAGESIZE 96
#define  NUMIMAGES 42
#define  NUMTILES  144

#define TRUE  1
#define FALSE 0

typedef char boolean;

/* define a tile */
typedef struct {
	Word *image;
	int value;
	int x_pos;
	int y_pos;
	boolean left_free;
	boolean right_free;
	boolean top_free;
	int left_next[2];
	int right_next[2];
	int covered[4];
	boolean removed;
} Tile;

/* window discriptor */
extern int wn;     

/* tile image definitions */
extern Word images[43][64];

/* blank tile definition */
/* extern Word blank[96];  */
#define blank images[42]

/* the 144 playing tiles */
extern Tile tiles[NUMTILES];

/* built-in pattern used for wrastop() */
/*    NA on a 5620
extern unsigned short patwhite[];
extern unsigned short patblack[];
*/

extern int	tile_count;
extern int	selected[2];
extern int	undo_tiles[144][2];
extern int	undo_count;
extern int	help_mode;
extern int	query_mode;
