
/*
 *	This program contains much of the code from the original
 *	 Sun version of mahjongg, written by Mark Holm, which was
 *	 inspired by the PC version.
 *
 *	This version of Mahjongg was modified/re-written/ported
 *	 for/to the AT&T UNIXPC    by Thomas Tkacik
 *                                 ...rphroy!tetnix!tet.
 *
 *	Any problems or comments should be addressed to Tom Tkacik
 *	 and not Mark Holm, who had nothing to do with this version
 *	 and will not be able to help you.
 *
 *	The 3b1 version was hacked/ported to a tty5620 terminal by
 *	Tommy Johnson, most of the 3b1 code was just commented out.
 *	Neither Mark Holm, or Thomas Tkacik know anything about this
 *	5620 version.
 *
 */

/*
 *	Copyright 1988, Mark Holm
 *			Exceptions
 *
 *	Permission is given to copy and distribute for non-profit purposes.
 *
 */

/*      This file has the event handlers for the background and
 *       tiles in the play panel
 */

/* 3b1 include files
#include <stdio.h>
#include <sys/types.h>
  #include <sys/mouse.h>
*/
#include<dmd.h>
#include "mahjongg.h"

#define MBUTR 1
#define MBUTM 2
#define MBUTL 4

int	undo_tiles[NUMTILES][2];
int	undo_count = 0;
int	help_mode = FALSE;
int	query_mode = FALSE;
int	tile_count;
int	selected[2];


/*******************************************/

/*
 * help the user -- show matching tiles
 */

help_proc()
{
	int         i;
	static int  parse[2] = { 0, 0 };

	if(selected[0] == -1) { /* find all pairs of matching tiles */

	     /* if not in help mode, initialize search */

		if(!(help_mode)) {
			help_mode = TRUE;
			parse[0] = 143;
			parse[1] = 142;
		}

	     /* look for a free tile */

		for(; parse[0] >= 0; parse[0]--) {
			if(!((tiles[parse[0]].top_free && 
		 	     (tiles[parse[0]].left_free ||
			      tiles[parse[0]].right_free) &&
			   (!(tiles[parse[0]].removed))))) {

				continue; /* not available -- try another */
			}

		     /* found a free tile */
		     /* check for a matching second tile */

			for(; parse[1] >= 0; parse[1]--) {
				if((tiles[parse[0]].value ==
						tiles[parse[1]].value) &&
				   (parse[0] != parse[1]) &&
			    	   (tiles[parse[1]].top_free &&
			           (tiles[parse[1]].left_free ||
						tiles[parse[1]].right_free) &&
			    	 (!(tiles[parse[1]].removed)))) {

			    	     /* Found a match -- show them */

			    		selected[0] = parse[0];
			    		selected[1] = parse[1];
			    		preview_tile(selected[0]);
			    		preview_tile(selected[1]);

				     /* does he need more help */

			    		wcmd(wn,"Show next move? [Y] [] [N]");

				     /* prepare for next help */

			    		parse[1]--;
			    		return;
				}
			}

		     /* no matching tile was found */
		     /* look for the next free tile */

		     /* going around again */

			parse[1] = parse[0] - 2;

		}

	     /* we found all matching tiles -- beep and leave help mode */

		help_mode = FALSE;
		window_bell();
		wcmd(wn,"");

	} else {  /* user selected one tile -- look for a match */

	    /* deselect previous choice if there was one */
	    /* and cancel preview of it */

		if (selected[1] != -1) {
			preview_tile(selected[1]);
			selected[1] = -1;
		}


	     /* if not in query mode then start the search */
	     /* otherwise, continue from last tile */

		if (!query_mode) {
			query_mode = TRUE;
			parse[0] = 143;
		}


		for(i = parse[0]; i >= 0; i--) {

		     /* is this a match */

			if ((tiles[i].value == tiles[selected[0]].value) &&
			    (i != selected[0]) &&
			    (tiles[i].top_free &&
			    (tiles[i].left_free || tiles[i].right_free) &&
			  (!(tiles[i].removed)))) {

			     /* yes, we found one */
			     /* show it */

				selected[1] = i;
				preview_tile(selected[1]);

			     /* does he want to remove them */

				wcmd(wn, "Please confirm. [Y] [NEXT] [N]");

			     /* return to sender */

				parse[0] = i - 1;
				return;
		    	}
		}

	     /* oops! could not find a match -- stop search */

		query_mode = FALSE;
		preview_tile(selected[0]);
		selected[0]= -1;
		wcmd(wn, "");
		window_bell();

    	}
}

/*
 * remove (or restore) selected tiles
 */

remove_tiles(REMOVE)
boolean	REMOVE;
{
	int	data[2];
	int	i;

	if (REMOVE) {   /* get tiles to be removed */

		data[0] = selected[0];
		data[1] = selected[1];

	} else { 	/* or those to be replaced */

		data[0] = undo_tiles[undo_count][0];
		data[1] = undo_tiles[undo_count][1];

	}

     /* adjust adjacent tiles */

	for(i = 0; i < 2 && tiles[data[0]].left_next[i] != -1; i++)
		tiles[tiles[data[0]].left_next[i]].right_free = REMOVE;

	for(i = 0; i < 2 && tiles[data[1]].left_next[i] != -1; i++)
		tiles[tiles[data[1]].left_next[i]].right_free = REMOVE;

	for(i = 0; i < 2 && tiles[data[0]].right_next[i] != -1; i++)
		tiles[tiles[data[0]].right_next[i]].left_free = REMOVE;

	for(i = 0; i < 2 && tiles[data[1]].right_next[i] != -1; i++)
		tiles[tiles[data[1]].right_next[i]].left_free = REMOVE;

     /* adjust covered tiles */

	for(i = 0; i < 4 && tiles[data[0]].covered[i] != -1; i++)
		tiles[tiles[data[0]].covered[i]].top_free = REMOVE;

	for(i = 0; i < 4 && tiles[data[1]].covered[i] != -1; i++)
		tiles[tiles[data[1]].covered[i]].top_free = REMOVE;

     /* set removed flags */

	tiles[data[0]].removed = REMOVE;
	tiles[data[1]].removed = REMOVE;

     /* remove confirm message */

	wcmd(wn, "");

	if (REMOVE) {

	     /* turn off preview */

		preview_tile(selected[0]);
		preview_tile(selected[1]);

	} else {

	     /* turn off preview of any selected tiles */

		if(selected[0] != -1) {
			preview_tile(selected[0]);
		}

		if(selected[1] != -1) {
			preview_tile(selected[1]);
		}
	}

     /* fix tile counter */

	tile_count += (REMOVE) ? -2 : 2;

	if (REMOVE) {

	     /* update undo_count */

		undo_count++;

	     /* update removed array */

		undo_tiles[undo_count][0] = selected[0];
		undo_tiles[undo_count][1] = selected[1];

	     /* check for clean board and congrat them */

		if(tile_count == 0) 
			wcmd(wn, "Congratulations!! Press 'SAME' 'NEW'");

	} else { /* decrement undo_count */
		undo_tiles[undo_count][0] = -1;
		undo_tiles[undo_count][1] = -1;
		undo_count--;
	}

     /* deselect tiles */
     /* we will redisplay the playing field so no need to unpreview */

	selected[0] = -1;
	selected[1] = -1;

     /* show the corrected playing field */

	draw_tiles();
}

/*
 * perform secondary mouse actions 
 */

play_back_proc(buton)
int		buton;
{

	if ((buton == MBUTM) && (selected[0] != -1) && !help_mode) {

	     /* he wants to be shown a matching tile */

		help_proc();

	} else {

		query_mode = FALSE;

		if (selected[1] != -1) { /* doing confirm  or next help */

			switch (buton) {

			case MBUTL:
				if (help_mode) {

				     /* cancel preview of selected tiles */

					preview_tile(selected[0]);
					preview_tile(selected[1]);

				     /* Clean up selected's variables */

					selected[0] = -1;
					selected[1] = -1;

				    /* do next help */

					help_proc();

				} else {

				     /* confirmed selection. remove them */

					remove_tiles(TRUE);

				}
				break;

			case MBUTR:

			     /* refused selection */

			     /* cancel preview of selected tiles */

				preview_tile(selected[0]);
				preview_tile(selected[1]);

			     /* Clean up selected's variables */

				selected[0] = -1;
				selected[1] = -1;

			     /* remove confirm message */

				wcmd(wn, "");

			     /* if in help mode toggle out */

				if (help_mode)
					help_mode = FALSE; 

				break;
			}
		}
    	}
}

/*
 * perform mouse action
 */

play_event_proc(i, buton)
int	i;
int	buton;
{
     /* check to see if in help_mode */

	if (help_mode || query_mode) {
		play_back_proc(buton);
		return;
	}

     /* check to see if just confirming */

	if (selected[1] != -1) {
		play_back_proc(buton);
		return;
	}

	switch(buton) {

	case MBUTL: 

	     /* Left button down begin selection */

	     /* if no tile is selected then just ignore it */
		if (i == -1)
			return;

		if (selected[0] == -1) {

		     /* select first tile of pair */

			selected[0] = i;
			preview_tile(selected[0]);

		} else if (selected[0] == i) {

		     /* deselect first tile */

			preview_tile(selected[0]);
			selected[0] = -1;

		} else if(tiles[selected[0]].value == tiles[i].value) {

		     /* select second tile */

			selected[1] = i;
			preview_tile(selected[1]);
			wcmd(wn, "Please confirm. [Y] [] [N]");
		
		} else {

		     /* illegal move -- beep at them */

			window_bell();
		}

		break;

	case MBUTM:
		if (selected[0] != -1) {

		     /* request for help */

			help_proc();
		}

		break;

		/* and all else shall pass */
	}
}

/*
 * undo the last move -- may be called repeatedly
 */

undo_proc()
{
	if(undo_count < 0)
		window_bell();
	else
		remove_tiles(FALSE);
}

