/*    This program rearranges the 3b1 bitmaps so a 5620 can handle them
**    (little/big endian problem)  It creates the file ./tiles/all (in
**    the Makefile).  Don't edit that file, instead edit the original
**    3b1 bitmaps.
**
**    This was written by Tommy Johnson.  
**    This code is in the Public domain.  If you want it, its yours
**    (though I wouldn't mind some credit  :-)
*/

#include<stdio.h>

extern long images[42][96];
extern long blank[96];
extern int errno;

char output[] = {'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};
hex(m)
unsigned long m;
{
	int i,j,d;
	unsigned long n;

	putchar('0');
	putchar('x');
	n=m;

	for(i=7;i>=0;i--)
	{
		d=0;
		for(j=0;j<4;j++)
			if(n & ((1 << j) << (i*4))) d|=(1 << j);
		putchar(output[d]);
	}
	putchar(',');
}

void puttile(tile)
long tile[32];
{
	int i,k;
	long t2,t;

	putchar('{');
	for(i=0;i<32;i++)
	{
		t2=(tile[(i*3)+1] << 16) | (tile[(i*3)]);
		t=0;
		for(k=0;k<32;k++)
			if (t2 & (1 << k)) t|=(0x80000000 >> k);
		hex(t);
		t=0;
		for(k=0;k<16;k++)
			if (tile[(i*3)+2] & (1 << k)) t|=(0x8000 >> k);
		hex(t << 16);
		putchar('\n');
	}
	putchar('}');
	putchar(',');
	putchar('\n');
}

int main()
{
	int i,j,k,l,t,t2;

	for(j=0;j<42;j++)
		puttile(images[j]);

	puttile(blank);

	errno=0;
	exit(0);
}
