#ifndef LAYERS_PROTOTYPES_H
#define LAYERS_PROTOTYPES_H

#include <poll.h>

/* psend.c
*/
int psend(int channel, char *bufp, int count);
int check_write(int fd, char *buf,int nbytes);
int netpsend(int channel, char *bufp, int count);
void flush_write(void);
int buf_write(int fd, char *buf, int nbytes);
int enc_write(int d, unsigned char *buf, int nbytes);

/* debug.c
*/
void Debug(int level,char * format, ...);
void DebugRaw(int xmit,char *buf, int nbytes);
void DebugInit(char *debugfname);

/* utmp_tty.c
*/
void savemode(int fd);
void setraw(int fd);
void setcntrl(int fd,char * ttyname);
void resetcntrl(int fd,char *ttyname);
int cntrlspeed(int fd);
void slavettyset(int fd, char *ttyname, struct winsize *wp);
void findsysfile(char *buf, char *file,int mode,char *msg);
char * callsysprog(char *argv[]);
void fixptyperms(int fd, char *tty,int release);
int allocpty(int lay, char *tty);
int getpty(int lay, char *tty);
void freepty(int lay, int fd, char *tty);
int matchtty(struct layer *lp, char *tty);
void initutmp(char *tty);
int moveutmp(int newlay);

/* multiplex.c
*/
int settopoll(int set,struct pollfd *pollfds);
int polltoset(int npollfds, struct pollfd *pollfds);
void multiplex(void);
int maxoutsize(int lay);
int isunacked(int lay);
int isdatapending(int req_set);
void deadkid(int setbits);
int mysleep(int seconds);

/* control.c
*/
int control(int lay,char * bp,int cc);
int allocchanpty(int lay);
int sendioctl(int lay,char jioctl);
struct winsize * getwinsize(struct layer *lp);
void startexit(void);

/* agent.c
*/
int initagent(char *tty);
int initagentenv(void);
void recvhostagent(int fd);
void recvagent(int recvlen,char * agntpt);
void startagent(void);
void rcfile(void);
char * agcmd(int lay);
int deleteterm(int lay,int start);
int agentcom(int chan, short command, short x1, short y1, short x2, short y2);
void exitagent(void);
void checkpendingagent(void);

/* process.c
*/
pid_t execprocess(char *tty,struct winsize *wp, char *cmd, int lay);
void catchsig(int signo);
void signalprocess(int lay,int sig);
void deletehost(int lay);
int pushmodules(int fd);

/* main.c
*/
void quit(int reset);

/* boot.c
*/
int boot(int fd);

/* pinit.c
*/
int protocolinit(int fd);
void xtprotoresp(short result, short maxpktresult);
int pinit(int channels);

/* trace.c
*/
void plogpkt(char *data, int size, char ident, char *badmsg);
int tracebyte(FILE *fp, unsigned char ch);
int tracebad(FILE *fp, char *badmsg, unsigned char *data, int size);
void tracelabels(FILE *fp);
int tracedatapart(FILE *fp, int xmit, int chan, unsigned char *data, int size);
int traceregular(FILE *fp, int xmit, unsigned char *data, int size);
int tracenet(FILE *fp, int xmit, unsigned char *data, int size);
void fptracepkt(FILE *fp, char *data, int size, char ident, char *badmsg, time_t stamp);
void fpdumphist(FILE *fp);
void pdumphist(char *s);
void fpsummary(FILE *fp);


/* ptimeout.c
*/
void ptimeout(int sig);

/* precv.c
*/
void precv(unsigned char *bufp, int count);

/* termio.c
*/
void termio_setcntrl(int fd);
void termio_resetcntrl(int fd);

/* pcheck.c
*/
int crc(unsigned char *buffer, int nbytes, int addcrctobuffer);

#endif
