/* */
/*									*/
/*	Copyright (c) 1987,1988,1989,1990,1991,1992   AT&T		*/
/*			All Rights Reserved				*/
/*									*/
/*	  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T.		*/
/*	    The copyright notice above does not evidence any		*/
/*	   actual or intended publication of such source code.		*/
/*									*/
/* */
/*
 * static char ID[] = "@(#) sdp.h: 1.1 3/16/82";
 */

#include <sys/types.h>

/* take spot audit */
#define AUDITNOW	2

/* turn audits off */
#define AUDITOFF	0

/* turn audits on */
#define AUDITON		1

/* error return from non pointer-valued functions */
#define	ERROR		(-1)

/* error return from id valued functions */

#define IDERROR		(-1l)

/* mnemonic to indicate an impossible itemid */
#define	IDNULL		(-2l)

/* turn error messages off */
#define MESGOFF		0

/* turn error messages on */
#define MESGON		1

/* successful return from non pointer-valued functions */
#define SUCCESS		1

/* permissions to change item for use */
#define	WRTN		2

/* permissions not to change item for use */
#define RNLY		0

/* macro for error conditions */
#define ERR_RET(f,r)	{FATAL(f) ; return(r) ;}
/*
 * If the user includes <stdio.h> ahead of "sdp.h," then sdp_hist will be
 * defined correctly as pointer to structure FILE; otherwise, sdp_hist will
 * be define as pointer to char.
 */

#ifdef FILE
#define MY_FILE	FILE
#else
#define MY_FILE	char
#endif

typedef	int32_t	ITEMID ;
typedef	int	FD ;
typedef	int32_t	BOUNDARY ;

struct SPACE				/* the structure to hold header file	*/
{
	int32_t	version ;		/* version number in form YYMMDD	*/
	unsigned page_size ;		/* number of bytes in a page		*/
	ITEMID	maxpage ;		/* highest byte allotted (page aligned)	*/
	ITEMID	curpage ;		/* id to current page during connection	*/
	unsigned curleft ;		/* number of bytes left in current page	*/
	int	perms ;			/* whether changes are enabled		*/
	int	mode ;			/* creation mode			*/
	int	numbfile ;		/* number of files comprising space	*/
	struct	FILEINFO *fileinfo ;	/* pointer to file information array	*/
	int	numbstax ;		/* number of allottment stacks	 	*/
	struct	STAXINFO *staxinfo ;	/* pointer to stack information array	*/
	char	*head_name ;		/* name of address space		*/
	ITEMID	known_id ;		/* for user				*/
	struct	ENVIRON *environ;	/* pointer to environment		*/
	struct	LIBFILE *lib_file ;	/* pointer to file library structure	*/
	struct	SPACE *next_space ;	/* link to next space			*/
	int32_t	sp1_hash ;		/* hash code for audits			*/
	int32_t	sp2_hash ;		/* hash code for audits			*/
} ;

struct STATS				/* structure to hold paging statistics	*/
{
	int32_t	uses ;			/* number of calls to sdp_use		*/
	int32_t	faults ;		/* number of page faults		*/
	int32_t	writes ;		/* number of faults causing writes	*/
	int	maxuse ;		/* largest number of frames in use	*/
	int	curuse ;		/* current number of frames in use	*/
} ;

struct ENVIRON				/* structure to describe memory setup 	*/
{
	int	num_frames ;		/* number of frames for swapping	*/
	unsigned frame_size ;		/* size of frames in bytes		*/
	int	empties ;		/* start of list of empty frames	*/
	int	cnct_count ;		/* spaces connected to this environment	*/
	struct	MANAGER *manp ;		/* pointer to array frame managers	*/
	struct	LIBMEM *lib_mem ;	/* pointer to memory library structure	*/
	struct	ENVIRON *next_environ ;	/* link to next environment		*/
	struct	STATS stats ;		/* holds paging statistics		*/
	int32_t	en_hash ;		/* hash code for audits			*/
} ;

struct FILEINFO				/* structure to hold file information	*/
{
	FD	desc ;			/* file descriptor			*/
	int32_t	leng ;			/* length of file in bytes		*/
} ;

struct STAXINFO				/* structure to hold stack information	*/
{
	ITEMID	top ;			/* itemid to top of stack		*/
	int32_t	size ;			/* size of items in stack		*/
	int32_t	depth ;			/* number of items in stack		*/
} ;

struct MANAGER				/* structure to manage frames		*/
{
	struct	SPACE *space ;		/* space identifier			*/
	ITEMID	page_id ;		/* byte offset in space			*/
	int32_t	usecount ;		/* number of use calls on this id	*/
	int	ref_chng ;		/* reference/change flag		*/
	int	forward ;		/* index of next manager		*/
	int	backward ;		/* index of previous manager		*/
	char	*frame_pntr ;		/* pointer to frame to be managed	*/
	int32_t	mn_hash ;		/* hash code for audits			*/
} ;

struct LIBFILE				/* pointers to file library functions	*/
{
	char * (*libbuildname)(char *, int) ;	/* pointer to name build function 	*/
	int (*libclose)(int) ;		/* pointer to file close function	*/
	int (*libcreate)(char *, int) ;		/* pointer to file create function	*/
	FD  (*libopen)(char *, int) ;		/* pointer to file open function	*/
	int (*libread)(int, char *, size_t) ;		/* pointer to file read function	*/
	int (*libseek)(int, off_t) ;		/* pointer to file position function	*/
	int (*libunlink)(char *) ;		/* pointer to file delete function	*/
	int (*libwrite)(int, char *, size_t) ;		/* pointer to file write function	*/
} ;

struct LIBMEM				/* pointers to memory library functions */
{
	int * (*liballoc)(int) ;		/* pointer to memory allocation function*/
	int   (*libfree)(void *) ;		/* pointer to memory free function	*/
} ;

#if 0
extern ITEMID		sdp_allot() ;
extern int		sdp_audit() ;
extern int		sdp_change() ;
extern struct SPACE 	*sdp_connect() ;
extern int		sdp_destroy() ;
extern int		sdp_disconnect() ;
extern int		sdp_generate() ;
extern MY_FILE	 	*sdp_hist() ;
extern struct ENVIRON 	*sdp_house() ;
extern int		sdp_redeem() ;
extern struct STATS	sdp_stats() ;
extern int		sdp_sync() ;
extern int		sdp_unuse() ;
extern BOUNDARY 	*sdp_use() ;
extern int		sdp_vacate() ;
#endif

int * ALLOC(int size);
char * BUILDNAME(char *name,int ordinal);
int CLOSE(FD designator);
int CREATE(char *name,int mode);
void FREE(void *ptr);
FD OPEN(char *name,int perms);
int READ(FD designator,char *buffer,int nbytes);
int SEEK(FD designator,int position);
int UNLINK(char *name);
int WRITE(FD designator,char *buffer,int nbytes);

ITEMID sdp_allot(struct SPACE *sp,unsigned int howmuch);
void FATAL(char *msg,...);
struct SPACE * sdp_connect(char *name,struct ENVIRON *environ, struct LIBFILE *library,int perms);
ITEMID pop_id(struct SPACE *sp,unsigned int howmuch);
int push_id(struct SPACE *sp, ITEMID id,unsigned int howmuch);
int sdp_audit(int mode);
void aud_set(void);
int aud_check(void);
void aud_reset(void);
int sdp_change(char *ptr);
int sdp_disconnect(struct SPACE *sp);
int sdp_generate(char *name,unsigned int page_size, struct LIBFILE *library,int mode);
MY_FILE * sdp_hist(char *name);
struct ENVIRON *sdp_house(int num_frames, unsigned int frame_size, struct LIBMEM *library);
int sdp_redeem(struct SPACE *sp,ITEMID id,unsigned int howmuch);
struct STATS sdp_stats(struct ENVIRON *environ);
int sdp_sync(struct SPACE *sp);
int sdp_unuse(struct SPACE *sp,ITEMID id,int permissions);
BOUNDARY *sdp_use(struct SPACE *sp,ITEMID id,int permissions);
int sdp_vacate(struct ENVIRON *environ);
int fault(struct SPACE *sp, ITEMID id);
struct SPACE *rdSPACE(char *name);
int readpage(struct SPACE *sp, ITEMID id,int frame);
int framesearch(struct SPACE *sp,ITEMID id);
int nextsearch(struct ENVIRON *environ);
int stk1search(struct SPACE *sp,unsigned int howmuch);
int stk2search(struct SPACE *sp,unsigned int howmuch);
int spsearch(struct SPACE *sp);
int ensearch(struct ENVIRON *en);
int writeframe(struct SPACE *sp,int frame);
int rem_frame(struct ENVIRON *environ,int frame);
void ins_frame(struct ENVIRON *environ,int frame, int position);
int wtSPACE(struct SPACE *sp);
void freeSPACE(struct SPACE *sp);
int sdp_copy(char *in_name, char *out_name, struct LIBFILE *library);

int sdp_destroy(char *name,struct LIBFILE *library);



extern int		mesg_flag ;
extern	char		*llaerrfile ;
extern ITEMID 		*known_idptr ;
