/* */
/*									*/
/*	Copyright (c) 1987,1988,1989,1990,1991,1992   AT&T		*/
/*			All Rights Reserved				*/
/*									*/
/*	  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T.		*/
/*	    The copyright notice above does not evidence any		*/
/*	   actual or intended publication of such source code.		*/
/*									*/
/* */
static char ID[] = "@(#) audit.c: 1.1 3/16/82";
#include <stdio.h>
#include "sdp.h"
#include "define3.h"

static int32_t hash1_gl(void);
static int32_t hash2_gl(void);
static int32_t hash_en(struct ENVIRON *env);
static int32_t hash1_sp(struct SPACE *sp);
static int32_t hash2_sp(struct SPACE *sp);
static int32_t hash_mn(struct MANAGER *man);

#ifdef SHORT
#define	AU01	"AU01 "
#define	AU02	"AU02 "
#define	AU03	"AU03 "
#define	AU04	"AU04 "
#define	AUAU	"AUAU "
#else
#define AU01	"%s","AU01 -- audit failure in global hash\n"
#define AU02	"%s","AU02 -- audit failure in space hash\n"
#define AU03	"%s","AU03 -- audit failure in environment hash\n"
#define AU04	"%s","AU04 -- audit failure in manager hash\n"
#define AUAU	"%s","AUAU -- audit failed in sdp_audit\n"
#endif

#define PROLOG		if( (aud_flag == AUDITON) && (aud_check() == ERROR) )\
				ERR_RET(AUAU,ERROR)
#define EPILOG		if(aud_flag == AUDITON)\
				aud_set() ;\
			if(hist_fp != NULL)\
				fprintf(hist_fp,"AU\t%d\n",mode) ;
#define RADIX	109

extern int aud_flag ;
extern int32_t compatible ;
extern int32_t gl1_hash ;
extern int32_t gl2_hash ;
extern struct ENVIRON *first_environ ;
extern struct SPACE *first_space ;
extern int Gnumbfile ;
extern int Gln_file[] ;
extern int Gnumbstax ;
extern int Gsz_stax[] ;
extern FILE *hist_fp ;
extern ITEMID *known_idptr ;
extern struct LIBFILE lib_file ;
extern struct LIBMEM lib_mem ;

int					/* SUCCESS or ERROR */
sdp_audit(int mode)
{
#ifndef SWEET

	PROLOG
	switch(mode)
	{
		case AUDITNOW:
			break ;

		case AUDITOFF:
			aud_flag = AUDITOFF ;
			aud_reset() ;
			break ;

		case AUDITON:
			aud_flag = AUDITON ;
			break ;
	}
	EPILOG
//	return(SUCCESS) ;
#endif
	return(SUCCESS) ;
}

void aud_set(void)
{
#ifndef SWEET
	struct SPACE *i ;
	struct ENVIRON *j ;
	int k ;
	int32_t hash1_gl(), hash2_gl(), hash1_sp(), hash2_sp(), hash_en(), hash_mn() ;

	gl1_hash = hash1_gl() ;
	gl2_hash = hash2_gl() ;

	for(i=first_space; i!=NULL; i=i->next_space)
	{
		i->sp1_hash = hash1_sp(i) ;
		i->sp2_hash = hash2_sp(i) ;
	}

	for(j=first_environ; j!=NULL; j=j->next_environ)
	{
		j->en_hash = hash_en(j) ;
		for(k=0; k<=j->num_frames; k++)
			(j->manp[k]).mn_hash = hash_mn(&(j->manp[k])) ;
	}
#endif
}
int					/* SUCCESS or ERROR */
aud_check(void)
{
#ifndef SWEET
	struct SPACE *i ;
	struct ENVIRON *j ;
	int k ;
	int32_t hash1_gl(), hash2_gl(), hash1_sp(), hash2_sp(), hash_en(), hash_mn() ;

	if( gl1_hash != hash1_gl()
	 || gl2_hash != hash2_gl() )
		ERR_RET(AU01,ERROR)

	for(i=first_space; i!=NULL; i=i->next_space)
		if( i->sp1_hash != hash1_sp(i)
		 || i->sp2_hash != hash2_sp(i) )
			ERR_RET(AU02,ERROR)

	for(j=first_environ; j!=NULL; j=j->next_environ)
	{
		if( j->en_hash != hash_en(j) )
			ERR_RET(AU03,ERROR)
		for(k=0; k<=j->num_frames; k++)
			if( (j->manp[k]).mn_hash != hash_mn(&(j->manp[k])) )
				ERR_RET(AU04,ERROR)
	}
//	return(SUCCESS) ;
#endif
	return(SUCCESS) ;
}

#ifndef SWEET
void aud_reset(void)
{

	struct SPACE *i ;
	struct ENVIRON *j ;
	int k ;

	gl1_hash = HASHNULL ;
	gl2_hash = HASHNULL ;

	for(i=first_space; i!=NULL; i=i->next_space)
	{
		i->sp1_hash = HASHNULL ;
		i->sp2_hash = HASHNULL ;
	}

	for(j=first_environ; j!=NULL; j=j->next_environ)
	{
		j->en_hash = HASHNULL ;
		for(k=0; k<j->num_frames; k++)
			(j->manp)[k].mn_hash = HASHNULL ;
	}
}

static int32_t					/* hash value */
hash1_gl(void)
{
	register int32_t	value ;

	value = (int32_t)first_environ ;
	value *= RADIX ;
	value += (int32_t)first_space ;
	value *= RADIX ;
	value += compatible ;
	value *= RADIX ;
	value += (int32_t)Gnumbfile ;
	value *= RADIX ;
	value += (int32_t)Gnumbstax ;
	value *= RADIX ;
	value += (int32_t)hist_fp ;
	value *= RADIX ;
	value += (int32_t)aud_flag ;
	value *= RADIX ;
	value += (int32_t)known_idptr ;
	value *= RADIX ;
	value += (int32_t)lib_file.libbuildname ;
	value *= RADIX ;
	value += (int32_t)lib_file.libclose ;
	value *= RADIX ;
	value += (int32_t)lib_file.libcreate ;
	value *= RADIX ;
	value += (int32_t)lib_file.libopen ;
	value *= RADIX ;
	value += (int32_t)lib_file.libread ;
	value *= RADIX ;
	value += (int32_t)lib_file.libseek ;
	value *= RADIX ;
	value += (int32_t)lib_file.libunlink ;
	value *= RADIX ;
	value += (int32_t)lib_file.libwrite ;
	value *= RADIX ;
	value += (int32_t)lib_mem.liballoc ;
	value *= RADIX ;
	value += (int32_t)lib_mem.libfree ;
	return(value) ;
}

static int32_t					/* hash value */
hash2_gl(void)
{
	register int32_t	value ;
	register int	i ;

	value = 0 ;
	for(i=0; i<Gnumbfile; i++)
	{
		value *= RADIX ;
		value += Gln_file[i] ;
	}
	for(i=0; i<Gnumbstax; i++)
	{
		value *= RADIX ;
		value += Gsz_stax[i] ;
	}
	return(value) ;
}

static int32_t					/* hash value */
hash_en(struct ENVIRON *env)
{
	register int32_t	value ;

	value = (int32_t)env->num_frames ;
	value *= RADIX ;
	value += (int32_t)env->frame_size ;
	value *= RADIX ;
	value += (int32_t)env->cnct_count ;
	value *= RADIX ;
	value += (int32_t)env->manp ;
	value *= RADIX ;
	value += (int32_t)env->empties ;
	value *= RADIX ;
	value += (int32_t)env->next_environ ;
	value *= RADIX ;
	value += env->stats.uses ;
	value *= RADIX ;
	value += env->stats.faults ;
	value *= RADIX ;
	value += env->stats.writes ;
	value *= RADIX ;
	value += (int32_t)env->stats.maxuse ;
	value *= RADIX ;
	value += (int32_t)env->stats.curuse ;
	return(value) ;
}

static int32_t					/* hash value */
hash1_sp(struct SPACE *sp)
{
	register int32_t	value ;

	value = sp->version ;
	value *= RADIX ;
	value += (int32_t)sp->page_size ;
	value *= RADIX ;
	value += sp->maxpage ;
	value *= RADIX ;
	value += sp->curpage ;
	value *= RADIX ;
	value += (int32_t)sp->curleft ;
	value *= RADIX ;
	value += (int32_t)sp->numbfile ;
	value *= RADIX ;
	value += (int32_t)sp->fileinfo ;
	value *= RADIX ;
	value += (int32_t)sp->numbstax ;
	value *= RADIX ;
	value += (int32_t)sp->staxinfo ;
	value *= RADIX ;
	value += (int32_t)sp->head_name ;
	value *= RADIX ;
	value += (int32_t)sp->environ ;
	value *= RADIX ;
	value += (int32_t)sp->next_space ;
	return(value) ;
}

static int32_t					/* hash value */
hash2_sp(struct SPACE *sp)
{
	register int32_t	value ;
	register int	i ;

	value = 0 ;
	for(i=0; i<sp->numbfile; i++)
	{
		value *= RADIX ;
		value += sp->fileinfo[i].leng ;
		value *= RADIX ;
		value += (int32_t)sp->fileinfo[i].desc ;
	}
	for(i=0; i<sp->numbstax; i++)
	{
		value *= RADIX ;
		value += sp->staxinfo[i].top ;
		value *= RADIX ;
		value += (int32_t)sp->staxinfo[i].size ;
		value *= RADIX ;
		value += sp->staxinfo[i].depth ;
	}
	return(value) ;
}

static int32_t					/* hash value */
hash_mn(struct MANAGER *man)
{
	register int32_t	value ;

	value = (int32_t)man->space ;
	value *= RADIX ;
	value += man->page_id ;
	value *= RADIX ;
	value += man->usecount ;
	value *= RADIX ;
	value += (int32_t)man->ref_chng ;
	value *= RADIX ;
	value += (int32_t)man->forward ;
	value *= RADIX ;
	value += (int32_t)man->backward ;
	value *= RADIX ;
	value += (int32_t)man->frame_pntr ;
	return(value) ;
}
#endif
