/* */
/*									*/
/*	Copyright (c) 1987,1988,1989,1990,1991,1992   AT&T		*/
/*			All Rights Reserved				*/
/*									*/
/*	  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T.		*/
/*	    The copyright notice above does not evidence any		*/
/*	   actual or intended publication of such source code.		*/
/*									*/
/* */
/* @(#) optutil.h: 1.3 3/27/84				*/
/* optutil.h
**
**	Declarations for 3B optimizer utilities
**
**	David Kristol, April, 1982
**/

extern boolean isreg();		/* is operand a register? */
extern boolean isnib();		/* is operand a nibble? */
extern boolean isnegnib();	/* is operand a negative nibble? */
extern int getbit();		/* get exponent if value is power of 2 */
extern NODE * insert();		/* insert new instruction node */
extern void chgop();		/* change op code */
extern char * copyopn();	/* copy operand */
extern boolean isdyadic();	/* is instruction dyadic? */
extern boolean istriadic();	/* is instruction triadic? */
extern boolean totriadic();	/* can dyadic be made triadic? */
extern void makelive();		/* make register live */
extern void makedead();		/* make register dead */
extern boolean isindex();	/* operand is an index off a register */
extern boolean ismove();	/* is instruction a move-type? */
extern boolean iszoffset();	/* is operand 0 offset from register? */
extern boolean isnumlit();	/* is operand a numeric literal: &[-]n? */
extern void exchange();		/* exchange node and successor */
extern boolean doindirect();	/* resolve indirect references in node */
extern boolean usesvar();	/* does first operand use second? */
boolean isiros(char *op );	/* is op either immed, reg, or on stack? */

extern void ldelin();	
extern void ldelin2();	/* routines to preserve */
extern void lexchin();
extern void lmrgin1();	/* line number info */
extern void lmrgin2();
extern void lmrgin3();

/* declare string and other functions that are always handy for optimizations */

#if 0
extern int strcmp();
extern char * strcpy();
extern int strlen();
extern char * strchr();
extern int32_t atol();
#else
#include <string.h>
#include <stdlib.h>
#endif


/* declare functions defined in local.c that are handy here */

char *dst(NODE *p);		/* return pointer to destination string */
int stype(int cop);		/* return implied type of op code */
boolean samereg(char *cp1,char *cp2);	/* return true if same register */
boolean usesreg(char *cp1,char *cp2);	/* usesreg(a,b) true if reg. b used in a */
int setreg(char *cp);		/* return bits corresponding to register */
boolean isdead(char *cp, NODE *p);	/* return true if reg. dead after node */
extern void wchange();		/* flag a window change */

