/* */
/*									*/
/*	Copyright (c) 1987,1988,1989,1990,1991,1992   AT&T		*/
/*			All Rights Reserved				*/
/*									*/
/*	  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T.		*/
/*	    The copyright notice above does not evidence any		*/
/*	   actual or intended publication of such source code.		*/
/*									*/
/* */
static char ID[] = "@(#) util.c: 1.8 2/27/84";
#include "system.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <stdarg.h>
#include <signal.h>
#include "structs.h"
#include "extrns.h"
#include "sgs.h"
#include "sgsmacros.h"
#include "y.tab.h"

void chkpower2(int32_t n);

/*eject*/
ACTITEM *
dfnscngrp(int type, ENODE *bondaddr, ENODE *align, ADDRESS *block)
{

/*
 * Build a AIDFNSCN/AIDFNGRP action item
 */

	ACTITEM *p;

	p = (ACTITEM *) mycalloc(sizeof(ACTITEM));

	p->dfnscn.aiinflnm = curfilnm;
	p->dfnscn.aiinlnno = lineno;
	p->dfnscn.aitype = type;
	p->dfnscn.aibndadr = NULL;
	p->dfnscn.aialign  = NULL;
	p->dfnscn.aiblock  =  0L;

	if ( bondaddr != NULL ) 	/* there is a bond */
		p->dfnscn.aibndadr = bondaddr;
	if (align != NULL) 		/* there is alignment */
		p->dfnscn.aialign = align;

	if (block) {
		p->dfnscn.aiblock = *block;
		chkpower2(*block);
		}

	return(p);
}
/*eject*/
void chkpower2(int32_t n)
{

/*
 * Determine if 'n' is a power of two
 */

	int32_t c;

	for( c = n; c > 2; c >>= 1 )
		if( (c % 2) == 1 ) {
			lderror(0, lineno, curfilnm, "%.1lx is not a power of 2", n );
			break;
			}
}
/*eject*/
char *
zero(char *ptr,int cnt)
{

/*
 * Zero "cnt" bytes starting at the address "ptr".
 * Return "ptr".
 */

	register char *p, *w;

	if( cnt > 0 ) {
		if( ((short) (p = ptr)) & 1 ) {
			*p++ = '\0';
			--cnt;
			}

		w = p + (cnt & (~1));
		while (p < w) {
			*((short *) p) = 0;
			p += sizeof(short);
			}

		if (cnt & 1)
			*p = '\0';
		}
	
	return( ptr );
}
/*eject*/
void zerofile(FILE *fildes,unsigned int *bptr, int bsiz)
#if 0
	FILE		*fildes;	/* write opened file */
	unsigned	*bptr;		/* zero filled buffer */
	int		bsiz;		/* size of buffer */
#endif
{
	int32_t	file_end;
	OUTSECT	*osptr;
/*
 * Insure that fildes is zero filled up to the point
 * of symbol table origin, or up to the last section if the symbol
 * table is stripped. Under TS, we simply seek to the point
 * and write one unsigned. Under RT or DMERT we must write 0's
 * throughout the entire space.
 */
	if (!sflag)
		file_end = symtborg - 4;
	else
	{
		file_end = 0L;
		for (osptr = (OUTSECT *) outsclst.head; osptr; osptr = osptr->osnext)
			file_end = max( file_end, osptr->oshdr.s_scnptr );

	}

#if RT
	rewind(fildes);
	while ( file_end > ftell(fildes) ) 
		fwrite( (char*) bptr, bsiz, 1, fildes);
#else
	fseek(fildes, file_end, 0);
	fwrite( (char *) bptr, sizeof(int32_t), 1, fildes);
#endif
	rewind(fildes);		/* leave everythiing as we found it */

	return;
}
/*eject*/
char *
sname(char *s)
{

/*
 * Returns pointer to "simple" name of path name; that is,
 * pointer to first character after last '/'.  If no slashes,
 * returns pointer to first char of arg.
 *
 * If the string ends in a slash:
 *	1. replace the terminating slash with '\0'
 *	2. return a pointer to the first character after the last
 *		'/', or the first character in the string
 */

	register char *p;

	p = s;
	while( *p )
		if(*p++ == '/')
		{
			if( *p == '\0' ) {
				*(p-1) = '\0';
				break;
				}
			else
				s = p;
		}
	return(s);
}




char *
myalloc(int nbytes)
{

/*
 * Allocate "nbytes" of memory, and exit from ld
 * upon failure.
 */

	register char *mem;

	if ((mem = malloc( nbytes )) == NULL )
	{
		lderror(0,0,NULL,
			"memory allocation failure on %d-byte 'malloc' call",
			nbytes);
		lderror(2,0,NULL, "%s run is too large and complex", SGS );
	}

#if PERF_DATA
	allocspc += (int32_t) nbytes;
#endif
	return(mem);
}


char *
mycalloc(int nbytes)
{

/*
 * Allocate "nbytes" of ZERO'D OUT memory, and exit from ld
 * upon failure.
 */

	register char *mem;

	if( (mem = calloc(1,nbytes)) == NULL )
	{
		lderror(0,0,NULL,
			"memory allocation failure on %d-byte 'calloc' call",
			nbytes);
		lderror(2,0,NULL, "%s run is too large and complex", SGS );
	}

#if PERF_DATA
	allocspc += (int32_t) nbytes;
#endif
	return(mem);
}


int stoi(char *p)
{

/*
 * Given a string of digits, perhaps beginning with "0" or "0x",
 * convert to an integer
 *
 * Return 0x8000 on any type of error
 */

	register int base, num;
	register char limit;

	num = 0;
	
	if (*p == '0') {
		if (*++p == 'x' || *p == 'X') {		/* string is hex */
			for (p++; *p; p++) {
				num <<= 4;
				if (*p >= '0' && *p <= '9')
					num += *p - '0';
				else if (*p >= 'a' && *p <= 'f')
					num += *p - 'a' + 10;
				else if (*p >= 'A' && *p <= 'F')
					num += *p - 'A' + 10;
				else return(0x8000);
				}
			return (num);
			}
		else {
			base = 8;
			limit = '7';
			}
		}
	else {
		base = 10;
		limit = '9';
		}

	for ( ; *p; p++)
		if( (*p >= '0')  &&  (*p <= limit) )
			num = num * base + *p - '0';
		else
			return(0x8000);

	return(num);
}



/*eject*/
/*VARARGS*/
void lderror(int lvl,int ln, char * fln,char *strng, ...)
#if 0
int lvl;		/* error severity level */
int ln;			/* line in ifile containing the error */
char *fln;		/* name of the ifile containing the error */
char *strng;		/* error message format */
int a1,a2,a3,a4,a5,	/* error message format arguments */
    a6,a7,a8,a9,aa;
#endif
{

/*
 *  Prepend a filename and a line number to an error message.
 *  used for printing all parsing-related errors.
 */
	va_list ap;
	errlev = (errlev < lvl ) ? lvl : errlev;

	if( Sflag  &&  (lvl != 2) )
		return;

	fprintf(stderr, "%sld", SGS);
	if (fln != NULL)
		fprintf(stderr, " %s", sname(fln));
	if ( ln > 0 )
		fprintf(stderr, " %d", ln) ;

	switch(lvl) {
	case 0:
		fprintf(stderr, " warning: ");
		break;
	case 2:
		fprintf(stderr, " fatal: ");
		break;
	default:
		fprintf(stderr, ": ");
		break;
	}

	va_start(ap,strng);
	vfprintf(stderr, strng, ap);
	va_end(ap);
	fprintf(stderr, "\n");
	fflush(stderr);

	if(lvl > 1)
		ldexit(0);
}




ENODE *
cnstnode(int32_t val)
{

/*
 * Build an expression node for a constant
 */

	register ENODE *p;

	p = (ENODE *) myalloc(sizeof(ENODE));

	p->vnode.exop = INT;
	p->vnode.exvalue = val;

	return(p);
}




void copy_section( FILE *infile, INFILE *infl, INSECT *isp, FILE *fdes, char *buffer, int32_t buf_size )
{
	register int32_t	more;
	register int32_t	num_bytes;

	more = isp->ishdr.s_size;
	while ( more )
	{
		num_bytes = min( buf_size, more );
		if (fread( buffer, (int) num_bytes, 1, infile ) != 1
			|| fwrite( buffer, (int) num_bytes, 1, fdes ) != 1)
			lderror( 2, 0, NULL, "cannot copy section %.8s of file %s", isp->ishdr.s_name, infl->flname);
		more -= num_bytes;
	}
}
