/* */
/*									*/
/*	Copyright (c) 1987,1988,1989,1990,1991,1992   AT&T		*/
/*			All Rights Reserved				*/
/*									*/
/*	  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T.		*/
/*	    The copyright notice above does not evidence any		*/
/*	   actual or intended publication of such source code.		*/
/*									*/
/* */
/*
 * static char ID_ldfcnh[] = "@(#) ldfcn.h: 1.3 5/1/83";
 */

/*
 *	The following two declarations appear in the IH versions of
 *	"stdio.h" but do not appear in the normal 1.2 versions.
 */

#include <stdio.h>
#include "linenum.h"
#include "syms.h"
#include "filehdr.h"
#include "scnhdr.h"

#ifndef LDFILE
struct	ldfile {
	int	_fnum_;		/* so each instance of an LDFILE is unique */
	FILE	*ioptr;		/* system I/O pointer value */
	int32_t	offset;		/* absolute offset to the start of the file */
	FILHDR	header;		/* the file header of the opened file */
	unsigned short	type;		/* indicator of the type of the file */
};


/*
	provide a structure "type" definition, and the associated
	"attributes"
*/

#define	LDFILE		struct ldfile
#define IOPTR(x)	x->ioptr
#define OFFSET(x)	x->offset
#define TYPE(x)		x->type
#define	HEADER(x)	x->header
#define LDFSZ		sizeof(LDFILE)

/*
	define various values of TYPE(ldptr)
*/

#define LDTYPE	B16MAGIC    /* defined in terms of the filehdr.h include file */
#define TVTYPE	TVMAGIC		/* ditto */
#if u3b5
#define USH_ARTYPE	ARTYPE
#else
#define USH_ARTYPE	(unsigned short) ARTYPE
#endif
#if defined(PORTAR) || defined(PORT5AR)
#define ARTYPE 	0177545
#else
#define ARTYPE	ARMAG
#endif

/*
	define symbolic positioning information for FSEEK (and fseek)
*/

#define BEGINNING	0
#define CURRENT		1
#define END		2

/*
	define a structure "type" for an archive header
*/

#if defined(PORTAR) || defined(PORT5AR)
typedef struct __attribute__((packed))
{
	char ar_name[16];
	int32_t ar_date;
	int ar_uid;
	int ar_gid;
	int32_t ar_mode;
	int32_t ar_size;
} archdr;

#define	ARCHDR	archdr
#else
#define	ARCHDR	struct ar_hdr	/* ARCHIVE is defined in ts.h */
#endif
#define ARCHSZ	sizeof(ARCHDR)


/*
	define some useful symbolic constants
*/

#define SYMTBL	0	/* section nnumber and/or section name of the Symbol Table */

#define	SUCCESS	 1
#define	CLOSED	 1
#define	FAILURE	 0
#define	NOCLOSE	 0
#define	BADINDEX	-1L

#define	OKFSEEK	0

/*
	define macros to permit the direct use of LDFILE pointers with the
	standard I/O library procedures
*/

LDFILE * ldopen(char *filename, LDFILE *ldptr);
LDFILE * ldaopen(char *filename,LDFILE *oldptr);


#define GETC(ldptr)	getc(IOPTR(ldptr))
#define GETW(ldptr)	getw(IOPTR(ldptr))
#define FEOF(ldptr)	feof(IOPTR(ldptr))
#define FERROR(ldptr)	ferror(IOPTR(ldptr))
#define FGETC(ldptr)	fgetc(IOPTR(ldptr))
#define FGETS(s,n,ldptr)	fgets(s,n,IOPTR(ldptr))
#define FILENO(ldptr)	fileno(IOPTR(ldptr))
#define DMDFREAD(p,s,n,ldptr)	fread(p,s,n,IOPTR(ldptr))
#define FSEEK(ldptr,o,p)	fseek(IOPTR(ldptr),(p==BEGINNING)?(OFFSET(ldptr)+o):o,p)
#define FTELL(ldptr)	ftell(IOPTR(ldptr))
#define DMDFWRITE(p,s,n,ldptr)       fwrite(p,s,n,IOPTR(ldptr))
#define REWIND(ldptr)	rewind(IOPTR(ldptr))
#define SETBUF(ldptr,b)	setbuf(IOPTR(ldptr),b)
#define UNGETC(c,ldptr)		ungetc(c,IOPTR(ldptr))
#define STROFFSET(ldptr)	(HEADER(ldptr).f_symptr + HEADER(ldptr).f_nsyms * 18) /* 18 == SYMESZ */

LDFILE *allocldptr(void);
int freeldptr(LDFILE *ldptr);
int ldaclose(LDFILE *ldptr);
int ldahread(LDFILE *ldptr, ARCHDR *arhead);
LDFILE * ldaopen(char *filename,LDFILE *oldptr);
int ldclose(LDFILE *ldptr);
int ldfhread(LDFILE *ldptr,FILHDR *filehead);
char * ldgetname(LDFILE *ldptr, SYMENT *symentry);
int ldlread(LDFILE *ldptr, int32_t fcnindx, unsigned short linenum,LINENO *linent);
int ldlseek(LDFILE *ldptr, unsigned short sectnum);
int ldnlseek(LDFILE *ldptr,char *sectname);
int ldnrseek(LDFILE *ldptr, char *sectname);
int ldnshread(LDFILE *ldptr, char *sectname, SCNHDR *secthdr);
int ldnsseek(LDFILE *ldptr,char *sectname);
int ldohseek(LDFILE *ldptr);
LDFILE * ldopen(char *filename, LDFILE *ldptr);
int ldrseek(LDFILE *ldptr, unsigned short sectnum);
int ldshread(LDFILE *ldptr, unsigned short sectnum, SCNHDR *secthdr);
int ldsseek(LDFILE *ldptr, unsigned short sectnum);
int32_t ldtbindex(LDFILE *ldptr);
int ldtbread(LDFILE *ldptr, int32_t symnum, SYMENT *symentry);
int ldtbseek(LDFILE *ldptr);

int32_t sgetl(char *buffer);
void sputl(int32_t w, char *buffer);
int vldldptr(LDFILE *ldptr);

int ldlinit(LDFILE *ldptr, int32_t fcnindex);
int ldlitem(LDFILE *ldptr,unsigned short linenum,LINENO *linent);

void lderror(int lvl,int ln, char * fln,char *strng, ...);
void ldexit(int);

#endif
