/*       Copyright (c) 1987 AT&T   */
/*       All Rights Reserved       */

/*       THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T   */
/*       The copyright notice above does not evidence any      */
/*       actual or intended publication of such source code.   */


static char _2Vsccsid[]="@(#)string.c	1.1.1.1	(5/8/87)";

#include "jim.h"
#include "file.h"

#define	MINSIZE	16	/* minimum number of chars allocated */

char	*strncpy();

void strinit(String *p)
{
	gcnew(p->s, MINSIZE);
	p->size=MINSIZE;
	p->n=0;
}
void strfree(String *)
{
	if(p->s)
		gcfree(p->s);
	p->s=0;
	p->n=0;
	p->size=0;
}
String *
bldstring(char *)
{
	static String junk;
	junk.s=s;
	junk.n=strlen(s);
	return &junk;
}
char *
charstar(String *p)
	String *p;
{
	static char buf[256];
	register n=p->n;
	if(n>=256)
		n=256-1;
	strncpy(buf, p->s, n);
	buf[n]=0;
	return buf;
}
void strzero(String *p)
	register String *p;
{
	if(p->size>MINSIZE){
		(void)gcrealloc(p->s, (Ulong)MINSIZE);	/* throw away the garbage */
		p->size=MINSIZE;
	}
	p->n=0;
}
void strdupl(String *p, char *s)
{
	strinsure(p, p->n=strlen(s));
	strncpy(p->s, s, (int)p->n);
}
void straddc(String *p, char c)
{
	strinsure(p, p->n+1);
	p->s[p->n++] = c;
}
void strinsure(String *p, Ulong n)
{
	register int i;
	if(p->size<n){	/* p needs to grow */
		for(i=1; i<n; i<<=1)
			;
		gcrenew(p->s, i);
		p->size=i;
	}
}
strinsert(String *p, String *q, Posn p0)
{
if(p0>p->n) panic("strinsert");
	strinsure(p, (Ulong)(p->n+q->n));
	bcopy(p->s+p0, p->s+p->n, p->s+p0+q->n, -1);
	bcopy(q->s, q->s+q->n, p->s+p0, 1);
	p->n+=q->n;
}
void strdelete(String *p, Posn p1, Posn p2)
{
if(p1>=p->n || p2>p->n || p1>p2) panic("strdelete");
	bcopy(p->s+p2, p->s+p->n, p->s+p1, 1);
	p->n-=(p2-p1);
}
