/*       Copyright (c) 1987 AT&T   */
/*       All Rights Reserved       */

/*       THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T   */
/*       The copyright notice above does not evidence any      */
/*       actual or intended publication of such source code.   */


/* static char _file_sccsid[]="@(#)file.h	1.1.1.1	(5/10/87)"; */

#define	NBLOCK		512
#define	BLOCKSIZE	(4096)

/*
 * Descriptor pointing to a disk block
 */
typedef struct{
	short	nbytes;	/* number of bytes used in this block */
	short	bnum;	/* which disk block it is */
}Block;
/*
 * Strings all live in a common buffer and are nicely garbage compacted.
 */
typedef struct{
	char	*s;	/* pointer to string */
	Ulong	n;	/* number used; s[n]==0 */
	Ulong	size;	/* size of allocated area */
}String;
String *bldstring();	/* (temporary String)-building function */
#define	DUBIOUS	1L	/* An unlikely date; means we don't know origin of buffer */
/*
 * A File is a local buffer for the in-core block
 * and an array of block pointers.  The order of the block pointers
 * in the file structure determines the order of the true data,
 * as opposed to the order of the bits in the file (c.f. ed temp files *).
 */
typedef struct File{
	String	name;		/* name of associated real file, "" if none */
	String	str;		/* storage for in-core data */
	long	date;		/* date file was read in */
	long	origin;		/* file location of first char on screen */
	long	selloc;		/* start location of selected text */
	long	nsel;		/* number of chars selected */
	int	curblk;		/* block associated with File.str */
	short	id;		/* id number for communication */
	char	changed;	/* changed since last write */
	short	nblocks;	/* number of blocks in File.block */
	short	nalloc;		/* number of blocks allocated */
	Block	*block;		/* array of block pointers */
	struct File *next;	/* list chain */
}File;
File *file;
String buffer;		/* Place to save squirreled away text */
String transmit;	/* String to send to Jerq */

File	*Fcreat();
File	*Fnew();
File	*Fload();
File	*Fileid();
long	length(), Fforwnl(), Fbacknl(), Fcountnl();
#define	YMAX	1024	/* as in jerq.h */
#define	DIAG	file
#define	TRUE	1
#define	FALSE	0
long	loc1, loc2;	/* location of searched-for string */
char	*strcpy();
int	fileschanged;


File * Fileid(int id);
File * Fnew(void);
File * Fcreat(File *f, char *s);
File * Fload(File *f);
int Fread(File *f, long posn, String *str, int setdate,int r);
int Fwrite(File *f, String *fname, int fd);
int Fwritepart(File *f, long posn, long nbytes, int fd);
void Fclose(File *f);
void Ffree(File *f);
void Freset(File *f);
void Fputblock(File *f);

long splitblock(File *f, long n);
long Fseek(File *f, long m);

long Fseek(File *f, long m);
long splitblock(File *f, long n);
void Fputblock(File *f);
void Fgetblock(File *f, int n);

void Read(char *s, int fd, char *a, int n);
void Write(char *s, int fd, char *a, Ulong n);

void Fdeltext(File *f, long m, long n);
void Fsave(File *f, String *b, long m, long n);

/* in string.c:
*/
void strinit(String *p);
void strfree(String *);
String * bldstring(char *);
char * charstar(String *p);
void strzero(String *p);

void strdupl(String *p, char *s);
void straddc(String *p, char c);
void strinsure(String *p, Ulong n);
void strinsert(String *p, String *q, Posn p0);
void strdelete(String *p, Posn p1, Posn p2);


/* in jim.c
*/

void modified(File *f);
void unmodified(File *f);
void tellseek(File *f);
